CREATE or REPLACE PROCEDURE proc_create_inventory_report (v_StateName CHAR) IS

v_CountyName station.county_name%type;
v_StateCode station.state_code%type;
v_StationCount number(5);

CURSOR c_Counties IS
	SELECT unique(county_name)
		FROM station
		WHERE state_name = v_StateName;

BEGIN

OPEN c_Counties;

	SELECT unique(state_code) INTO v_StateCode
	FROM station
	WHERE state_name = v_StateName;

LOOP
	FETCH c_Counties INTO v_CountyName;
	Exit WHEN c_Counties%NOTFOUND;

	SELECT count(computer_sequence_number) INTO v_StationCount
	FROM station
	WHERE county_name = v_CountyName
	AND state_name = v_StateName;

	dbms_output.enable(10000000);
	dbms_output.put_line('SPOOL D:/joe/'||TRANSLATE(TRIM(v_StateName), ' ', '_')||'/'||TRANSLATE(TRIM(v_StateCode), ' ', '_')||'_'||TRANSLATE(TRIM(v_CountyName), ' ', '_')||'_inv.txt');
	dbms_output.put_line('ttitle Left '''||trim(v_CountyName)||', '||v_StateCode||''' SKIP ''Number of Stations = '||v_StationCount||''' SKIP 3');
	dbms_output.put_line('SELECT RES.fk_parameter_code AS "Code", PAR.short_name01||'' ''||PAR.short_name02||'' ''||PAR.short_name03 as "Short Name", PAR.long_name as "Long Name",');
	dbms_output.put_line('TO_CHAR(COUNT(DISTINCT(computer_sequence_number))) AS "#stations", TO_CHAR(COUNT(result_value)) AS "#obs", TO_CHAR(MIN(start_date),''YYYY-MM-DD'') AS "First Date", TO_CHAR(MAX(start_date),''YYYY-MM-DD'') AS "Last Date",');
	dbms_output.put_line('CASE WHEN TEST_NUMBER(MIN(result_value))=''Y'' THEN  TO_CHAR(MIN(result_value), ''9.99EEEE'') ELSE MIN(result_value) END AS "Min Value",'); 
	dbms_output.put_line('CASE WHEN TEST_NUMBER(MAX(result_value))=''Y'' THEN  TO_CHAR(MAX(result_value), ''9.99EEEE'') ELSE MAX(result_value) END AS "Max Value",');
	dbms_output.put_line('AVG(CASE WHEN TEST_NUMBER(result_value)=''Y'' THEN result_value ELSE NULL END) AS "avg_res"');
	dbms_output.put_line('FROM storet_owner.result RES, storet_owner.sample SAM, station STA, storet_owner.parameter PAR');
	dbms_output.put_line('WHERE RES.fk_parameter_code = PAR.code');
	dbms_output.put_line('and RES.fk_sample_code_isn=SAM.sample_code_isn');
	dbms_output.put_line('and SAM.fk_computer_sequence_number=STA.computer_sequence_number');
	dbms_output.put_line('and STA.state_name='''||trim(v_StateName)||'''');
	dbms_output.put_line('and STA.county_name='''||trim(v_CountyName)||'''');
	dbms_output.put_line('GROUP BY RES.fk_parameter_code,PAR.long_name,PAR.short_name01||'' ''||PAR.short_name02||'' ''||PAR.short_name03;');
	dbms_output.put_line('SPOOL OFF');

END LOOP;
CLOSE c_Counties;

END;
/
SHOW ERRORS;